# pirs_front

Проект разработки frontend составляющей ЦП Пирс

## Характеристики

Проект создан с помощью пакета <a href='https://github.com/facebook/create-react-app'>create-react-app</a>

Основные пакеты:

- "react": "^16.13.1"
- "redux": "^4.0.5"
- "typescript": "^4.0.3"

<b>Для запуска и разворота проекта необходимо установить <a href='https://nodejs.org/en/download/'>nodeJS</a> пакет на ОС. </b>

## Разворот проекта

I. Склонировать проект

- SSH git@gitlab.bimit.ru:pirs/pirs_front.git
- HTTPS https://gitlab.bimit.ru/pirs/pirs_front.git

II. Скачать необходимые пакеты

- yarn install (Необходим пакетный менеджер <a href='https://classic.yarnpkg.com/en/docs/install/#windows-stable'>yarn</a>)
- npm install (Необходим пакетный менеджер <a href='https://classic.yarnpkg.com/en/docs/install/#windows-stable'>yarn</a>)

III. Скрипты запусков

- react-scripts start (запускает проект, http://localhost:3000)
- react-scripts build (собирает билд проекта под прод, ...projectPath\build)
- react-scripts test (запускает тесты)
- react-scripts test --coverage --watchAll=false (запускает проверку покрытия тестами)
- yarn test --updateSnapshot (Обновляет снапшоты верстки компонентов, что нужны для тестов)
- prettier --write src/\*\*/*.{js,jsx,ts,tsx} (Перебирает все файлы проекта и форматирует их под единный стандарт)
- eslint --fix src/\*\*/\*.{js,jsx,ts,tsx} src/\*\*/\*.stories.{js,jsx,ts,tsx} (Перебирает все файлы, проверяет их линтером и форматирует под один стандарт)
- start-storybook -p 6006 -s public (Формирует библиотеку компонентов проекта, для просмотра)
- build-storybook -s public (Формирует билд библиотеки компонентов)
- typedoc --out docs src/utils (Формирует выдержку документации)
- react-scripts eject (открывает все конфиги проекта, такие как webpack.config, babel и тд. Использовать с осторожностью)

## Документация

[Документация](documentation/README.md)